<?php 

if (is_singular('apartments')) {
	$query_id = get_the_ID();	
	// $terms = get_the_terms( get_the_ID(), 'apartment_category');
	$terms = get_terms('apartment_category', array( 'parent' => 0 ) );	
	$ap_term = array_pop($terms);	
	$invest_cat = get_field('invest_cat',$ap_term);
	$term = 'building_category_' . $invest_cat->term_id;
} elseif (is_singular('premises')) {
	$query_id = get_the_ID();
	// $terms = get_the_terms( get_the_ID(), 'apartment_category');
	$terms = get_terms('premises_category', array( 'parent' => 0 ) );	
	if ($terms) $ap_term = array_pop($terms);	
	if (get_field('invest_contact',$ap_term)) {
		$invest_cat = get_field('invest_cat',$ap_term);
		$term = 'building_category_' . $invest_cat->term_id;
	} else {
		$term = $ap_term;
	}
} elseif (is_singular('buildings') and $post->post_parent) {
	$query_id = wp_get_post_parent_id(get_the_ID());
	$terms = get_the_terms( $query_id, 'building_category');
	$term = array_pop($terms);
} else {	
	$query_id = get_the_ID();
	$terms = get_the_terms( $query_id, 'building_category');
	//$term = 'building_category_' . get_the_ID();
	$term = array_pop($terms);
}

if (is_singular('premises') and get_field('show_premises_people', 'option') and get_field('premises_people_type','option') == 'repeater')
	$people = 'premises_people';
else
	$people = 'people';

if ((get_field('people_type',$term) == 'post_object' and get_field('show_people_team',$term)) or (get_field('people_type',$term) == 'repeater' and have_rows($people,$term))) {
	$term_people = $term; }
elseif (have_rows($people,'option')) {
	$term_people = 'option';
}

if (is_singular('premises') and get_field('show_premises_people', 'option') and get_field('premises_people_type','option') == 'repeater') {
	$people_type = get_field('premises_people_type',$term_people);
	$people_team = get_field('show_premises_people_team',$term_people);
} else {
	$people_type = get_field('people_type',$term_people);
	$people_team = get_field('show_people_team',$term_people);
}

if ($people_team and $people_type == 'post_object') { ?>
	<div id="carousel-people" class="carousel slide row people-box wow fadeIn" data-wow-delay="500ms" data-ride="carousel">
		<div class="col-sm-16 col-sm-offset-4">
			<div class="carousel-inner people" role="listbox">
				<?php $c = 1;$delay = 50;
				foreach( $people_team as $post) { // variable must be called $post (IMPORTANT)
					setup_postdata($post); ?>
					<div class="item<?php if ($c == 1) echo ' active'; ?>">
						<?php if (has_post_thumbnail()) { ?>
							<div class="col-sm-8 people-image omega hidden-xs">
								<div class="people-image-content">
									<?php the_post_thumbnail(); ?>
								</div>
							</div>
							<div class="col-sm-16 people-text-box alpha">
						<?php } else { ?>
							<div class="col-sm-24">
						<?php } ?>
								<div class="people-text">
									<div class="people-text-container">
										<h3><?php the_title(); ?></h3>
										<?php if (get_field('position')) { ?>
											<p class="position"><?php the_field('position'); ?></p>
										<?php } ?>
										<?php if (get_field('phone') or get_field('email')) { ?>
											<p class="people-contact">
												<?php if (get_field('phone')) { ?>
													<a href="tel:<?php the_field('phone'); ?>"><i class="fa fa-phone" aria-hidden="true"></i> <?php the_field('phone'); ?></a>
												<?php } ?>
												<?php if (get_field('email')) { ?>
													<a href="mailto:<?php the_field('email'); ?>"><i class="fa fa-envelope" aria-hidden="true"></i> <?php the_field('email'); ?></a>
												<?php } ?>
											</p>
										<?php } ?>
									</div>
								</div>
							</div>
					</div>					
				<?php if (count($people_team) == $c) break;
				$c++;$delay + 200;
				} ?>
			</div>
			<?php if (count($people_team) > 1) { ?>
				<ol class="carousel-indicators">
					<?php $c = 1;
					foreach( $people_team as $post) { ?>
						<li data-target="#carousel-people" data-slide-to="<?php echo $c; ?>"<?php if ($c == 1) { ?> class="active"<?php } ?>></li>
					<?php if (count($people_team) == $c) break;
					$c++;
					} ?>
				</ol>
			<?php } ?>
		</div>
	</div>
	<?php wp_reset_postdata();
	
} elseif ($people_type == 'repeater' and have_rows($people,$term_people)) {	?>
	<div id="carousel-people" class="carousel slide row people-box wow fadeIn" data-wow-delay="500ms" data-ride="carousel">
		<div class="col-sm-16 col-sm-offset-4">
			<div class="carousel-inner people" role="listbox">
				<?php $c = 0;$delay = 50;
				while ( have_rows($people,$term_people) ) { the_row();
					$person_image = get_sub_field('person_image'); ?>
					<div class="item<?php if ($c == 0) echo ' active'; ?>">
						<?php if ($person_image) { ?>
							<div class="col-sm-8 people-image omega hidden-xs">
								<div class="people-image-content">
									<img src="<?php echo $person_image['url']; ?>">
								</div>
							</div>
							<div class="col-sm-16 people-text-box alpha">
						<?php } else { ?>
							<div class="col-sm-24">
						<?php } ?>
								<div class="people-text">
									<div class="people-text-container<?php if ($person_image) echo ' no-border-left'; ?>">
										<?php if (get_sub_field('name')) { ?>
											<h3><?php the_sub_field('name'); ?></h3>
										<?php } ?>
										<?php if (get_sub_field('position')) { ?>
											<p class="position"><?php the_sub_field('position'); ?></p>
										<?php } ?>
										<?php if (get_sub_field('phone') or get_sub_field('email')) { ?>
											<p class="people-contact">
												<?php if (get_sub_field('phone')) { ?>
													<a href="tel:<?php the_sub_field('phone'); ?>"><i class="fa fa-phone" aria-hidden="true"></i> <?php the_sub_field('phone'); ?></a>
												<?php } ?>
												<?php if (get_sub_field('email')) { ?>
													<a href="mailto:<?php the_sub_field('email'); ?>"><i class="fa fa-envelope" aria-hidden="true"></i> <?php the_sub_field('email'); ?></a>
												<?php } ?>
											</p>
										<?php } ?>
									</div>
								</div>
							</div>
					</div>					
				<?php $c++;$delay + 200;
				} ?>
			</div>
			<?php if (count(get_field($people,$term_people)) > 1) { ?>
				<ol class="carousel-indicators">
					<?php $c = 0;
					while ( have_rows($people,$term_people) ) { the_row(); ?>
						<li data-target="#carousel-people" data-slide-to="<?php echo $c; ?>"<?php if ($c == 0) { ?> class="active"<?php } ?>></li>
					<?php $c++;
					} ?>
				</ol>
			<?php } ?>
		</div>
	</div>
<?php } ?>